@replaceMethod(ExitFromVehicle)
  protected func Activate(context: ScriptExecutionContext) -> Void {
    let VehDoorRequestEvent: ref<VehicleExternalDoorRequestEvent>;
    let mountInfo: MountingInfo;
    let ownerPuppet: wref<ScriptedPuppet>;
    let slotName: CName;
    let unmountingEvt: ref<VehicleStartedMountingEvent>;
    let vehicle: wref<VehicleObject>;
    let workspotSystem: ref<WorkspotGameSystem>;
    ScriptExecutionContext.SetArgumentScriptable(context, n"ActiveMountRequest", null);
    VehDoorRequestEvent = new VehicleExternalDoorRequestEvent();
    unmountingEvt = new VehicleStartedMountingEvent();
    mountInfo = GameInstance.GetMountingFacility(ScriptExecutionContext.GetOwner(context).GetGame()).GetMountingInfoSingleWithObjects(ScriptExecutionContext.GetOwner(context));
    vehicle = GameInstance.FindEntityByID(ScriptExecutionContext.GetOwner(context).GetGame(), mountInfo.parentId) as VehicleObject;
    slotName = mountInfo.slotId.id;
    VehDoorRequestEvent.slotName = vehicle.GetBoneNameFromSlot(slotName);
    VehDoorRequestEvent.autoClose = true;
    unmountingEvt.slotID = slotName;
    unmountingEvt.isMounting = false;
    unmountingEvt.character = ScriptExecutionContext.GetOwner(context);
    workspotSystem = GameInstance.GetWorkspotSystem(ScriptExecutionContext.GetOwner(context).GetGame());
    if IsDefined(workspotSystem) {
      ownerPuppet = ScriptExecutionContext.GetOwner(context) as ScriptedPuppet;
      if this.useFastExit {
	  
		let defaultVec3: Vector3;
		defaultVec3.X = 0;
		defaultVec3.Y = 0;
		defaultVec3.Z = 0;

        workspotSystem.SendFastExitSignal(ScriptExecutionContext.GetOwner(context), defaultVec3, false, true, true, this.tryBlendToWalk);
      } else {
	  
		//Move them more out of the vehicle bc it's buggy
		
		//Default stuff because we can't skip parameters in redscript
		let defaultOrientation: Quaternion = ownerPuppet.GetWorldOrientation();
		let defaultVector: Vector4;
		defaultVector.X = 0;
		defaultVector.Y = 0;
		defaultVector.Z = 0;
		defaultVector.W = 1;

		//Get direction of the vehicle, and increase our unmount distance at a 90 degree angle to that, depending on seat
		let vehicleForward: Vector4 = vehicle.GetWorldForward();
		let unmountForward: Vector4;
		let unmountDist: Vector4;
		if Equals(slotName, n"seat_front_left") || Equals(slotName, n"seat_back_left"){
			unmountForward = Vector4.RotByAngleXY(vehicleForward, 90.0);
		}
		else{
			unmountForward = Vector4.RotByAngleXY(vehicleForward, -90.0);
		};
		unmountDist = unmountForward * TweakDBInterface.GetFloat(t"VCUnmountingDistance", 1);
		unmountDist.W = 1;

        if IsDefined(ownerPuppet) && Equals(ownerPuppet.GetHighLevelStateFromBlackboard(), gamedataNPCHighLevelState.Combat) {
          workspotSystem.UnmountFromVehicle(vehicle, ScriptExecutionContext.GetOwner(context), false, unmountDist, defaultOrientation, n"default"); //Use default instead of combat exiting because the combat exiting can make NPC's get out in middle of vehicle
        } else {
          workspotSystem.UnmountFromVehicle(vehicle, ScriptExecutionContext.GetOwner(context), false, defaultVector, defaultOrientation, n"default");

        };
      };
    };
    if VehicleComponent.IsDriver(ScriptExecutionContext.GetOwner(context).GetGame(), ScriptExecutionContext.GetOwner(context)) {
      this.SendAIEventToMountedVehicle(context, n"NoDriver");
    };
    vehicle.QueueEvent(unmountingEvt);
    vehicle.QueueEvent(VehDoorRequestEvent);
  }


//Add some thingies that hopefully maybe do something probably
@replaceMethod(AIDriveCommandsDelegate)
  public final func DoStartDriveFollow(context: ScriptExecutionContext) -> Bool {
    let cmd: ref<AIVehicleFollowCommand> = this.m_driveFollowCommand;
    this.useKinematic = true;
    this.needDriver = cmd.needDriver;
    this.target = cmd.target;
    this.secureTimeOut = cmd.secureTimeOut;
    this.distanceMin = cmd.distanceMin;
    this.distanceMax = cmd.distanceMax;
    this.stopWhenTargetReached = cmd.stopWhenTargetReached;
    this.useTraffic = cmd.useTraffic;
    this.trafficTryNeighborsForStart = cmd.trafficTryNeighborsForStart;
    this.trafficTryNeighborsForEnd = cmd.trafficTryNeighborsForEnd;
    this.allowStubMovement = true;
    return true;
  }
  
